/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.swparasites.items;

import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.existingeevee.swparasites.config.ParasiteSWConfig;
import com.existingeevee.swparasites.handlers.EvolutionHandler;
import com.existingeevee.swparasites.items.IHasSRPEvolutionProgress;
import com.oblivioussp.spartanweaponry.api.IWeaponCallback;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBolt;
import com.oblivioussp.spartanweaponry.init.ItemRegistrySW;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import com.oblivioussp.spartanweaponry.item.ItemBolt;
import com.oblivioussp.spartanweaponry.item.ItemCrossbow;
import com.oblivioussp.spartanweaponry.util.NBTHelper;
import com.oblivioussp.spartanweaponry.util.Quaternion;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemParasiteCrossbow
extends ItemCrossbow
implements IHasSRPEvolutionProgress {
    public static final String NBT_MULTI_REMAINING = "multiRemaining";
    public static final String NBT_MULTI_COOLDOWN = "multiCooldown";
    public static final String NBT_MULTI_ARROW = "multiArrow";
    public static final String NBT_MULTI_ACC = "multiAcc";
    public static final int TICKS_BETWEEN_SHOTS = 2;
    int multiAmount = 0;
    boolean living = true;

    public ItemParasiteCrossbow setLiving(boolean living) {
        this.living = living;
        return this;
    }

    public ItemParasiteCrossbow(String unlocName, String externalModId, ToolMaterialEx material, IWeaponCallback weaponCallback) {
        super(unlocName, externalModId, material, weaponCallback);
    }

    public ItemParasiteCrossbow(String unlocName, String externalModId, ToolMaterialEx material) {
        super(unlocName, externalModId, material);
    }

    public ItemParasiteCrossbow(String unlocName, ToolMaterialEx toolMaterial) {
        super(unlocName, toolMaterial);
    }

    public ItemParasiteCrossbow withMultiAmount(int newAmount) {
        this.multiAmount = newAmount;
        return this;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (NBTHelper.getInteger((ItemStack)stack, (String)NBT_MULTI_REMAINING) <= 0) {
            return super.func_77654_b(stack, worldIn, entityLiving);
        }
        return stack;
    }

    public int getAimTicks(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemParasiteCrossbow) {
            float mult = (float)(1.0 + (this.living ? ParasiteSWConfig.weaponSlowness * 1.2 : ParasiteSWConfig.weaponIISlowness * 1.4));
            return Math.round((float)super.getAimTicks(stack) * mult);
        }
        return super.getAimTicks(stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            int i;
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammoStack = ItemStack.field_190927_a;
            NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack, (String)"ammoStack");
            if (tag != null) {
                ammoStack = new ItemStack(tag);
            }
            if ((i = this.func_77626_a(stack) - timeLeft) < 0 || !NBTHelper.getBoolean((ItemStack)stack, (String)"isLoaded")) {
                return;
            }
            if (!ammoStack.func_190926_b() || flag) {
                boolean flag1;
                if (ammoStack.func_190926_b()) {
                    ammoStack = new ItemStack((Item)ItemRegistrySW.bolt);
                }
                boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || ammoStack.func_77973_b() instanceof ItemBolt && ((ItemBolt)ammoStack.func_77973_b()).isInfinite(ammoStack, stack, entityplayer);
                if (!worldIn.field_72995_K) {
                    ItemBolt itemBolt = ammoStack.func_77973_b() instanceof ItemBolt ? ammoStack.func_77973_b() : ItemRegistrySW.bolt;
                    int aimTicks = this.getAimTicks(stack);
                    int inaccuracy = aimTicks - i;
                    float inaccuracyModifier = 0.0f;
                    if (i >= aimTicks) {
                        inaccuracy = 0;
                    }
                    if (inaccuracy != 0) {
                        inaccuracyModifier = 10.0f * ((float)inaccuracy / (float)aimTicks);
                    }
                    this.attemptFire(stack, ammoStack, itemBolt, worldIn, entityplayer, flag1, inaccuracyModifier);
                    this.initMulti(stack, ammoStack, inaccuracyModifier);
                    int damage = ammoStack.func_190916_E() > 1 ? 3 : 1;
                    stack.func_77972_a(damage, (EntityLivingBase)entityplayer);
                    NBTHelper.setBoolean((ItemStack)stack, (String)"isLoaded", (boolean)false);
                    NBTHelper.setTagCompound((ItemStack)stack, (String)"ammoStack", (NBTTagCompound)new NBTTagCompound());
                }
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    protected void spawnProjectile(ItemStack crossbow, ItemBolt boltItem, ItemStack boltStack, World world, EntityPlayer player, boolean noPickup, float inaccuracyModifier, float projectileAngle) {
        int k;
        EntityBolt bolt = boltItem.createBolt(world, boltStack, (EntityLivingBase)player);
        bolt.func_70243_d(true);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d vector = new Vec3d(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
        if (projectileAngle != 0.0f) {
            Vec3d playerUpVec = this.calculateEntityViewVector(player.field_70125_A - 90.0f, player.field_70177_z);
            Quaternion quat = new Quaternion(playerUpVec, projectileAngle, true);
            vector = quat.transformVector(lookVec);
        }
        bolt.func_70186_c(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c, this.getBoltSpeed() * 3.0f, inaccuracyModifier);
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)crossbow);
        if (j > 0) {
            bolt.func_70239_b(bolt.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)crossbow)) > 0) {
            bolt.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)crossbow) > 0) {
            bolt.func_70015_d(100);
        }
        if (noPickup || projectileAngle != 0.0f) {
            bolt.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        bolt.func_184216_O().add("ParasiteCrossbowMultifire");
        world.func_72838_d((Entity)bolt);
    }

    public void attemptFire(ItemStack stack, ItemStack ammoStack, ItemBolt itemBolt, World worldIn, EntityPlayer player, boolean flag1, float inaccuracyModifier) {
        this.spawnProjectile(stack, itemBolt, ammoStack, worldIn, player, flag1, inaccuracyModifier, 0.0f);
        if (ammoStack.func_190916_E() > 1) {
            this.spawnProjectile(stack, itemBolt, ammoStack, worldIn, player, true, inaccuracyModifier, -10.0f);
            this.spawnProjectile(stack, itemBolt, ammoStack, worldIn, player, true, inaccuracyModifier, 10.0f);
        }
        NBTHelper.setInteger((ItemStack)stack, (String)NBT_MULTI_COOLDOWN, (int)2);
        float vel = this.getBoltSpeed();
        worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundRegistry.CROSSBOW_FIRE, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + vel * 0.5f);
    }

    public void initMulti(ItemStack stack, ItemStack ammoStack, float accMod) {
        NBTHelper.setInteger((ItemStack)stack, (String)NBT_MULTI_REMAINING, (int)this.multiAmount);
        ItemStack boltToStore = ammoStack.func_77946_l();
        NBTTagCompound nbtBolt = new NBTTagCompound();
        boltToStore.func_77955_b(nbtBolt);
        NBTHelper.setTagCompound((ItemStack)stack, (String)NBT_MULTI_ARROW, (NBTTagCompound)nbtBolt);
        NBTHelper.setFloat((ItemStack)stack, (String)NBT_MULTI_ACC, (float)accMod);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        int multiAmount = NBTHelper.getInteger((ItemStack)stack, (String)NBT_MULTI_REMAINING);
        if (multiAmount > 0 && entityIn instanceof EntityPlayer && !worldIn.field_72995_K) {
            int cooldown = NBTHelper.getInteger((ItemStack)stack, (String)NBT_MULTI_COOLDOWN);
            if (cooldown > 0) {
                NBTHelper.setInteger((ItemStack)stack, (String)NBT_MULTI_COOLDOWN, (int)(cooldown - 1));
            } else {
                float accMod = NBTHelper.getFloat((ItemStack)stack, (String)NBT_MULTI_ACC);
                ItemStack ammoStack = ItemStack.field_190927_a;
                NBTTagCompound tag = NBTHelper.getTagCompound((ItemStack)stack, (String)"ammoStack");
                if (tag != null) {
                    ammoStack = new ItemStack(tag);
                }
                ItemBolt itemBolt = ammoStack.func_77973_b() instanceof ItemBolt ? (ItemBolt)ammoStack.func_77973_b() : ItemRegistrySW.bolt;
                this.attemptFire(stack, ammoStack, itemBolt, worldIn, (EntityPlayer)entityIn, true, accMod);
                NBTHelper.setInteger((ItemStack)stack, (String)NBT_MULTI_REMAINING, (int)(multiAmount - 1));
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            if (ParasiteSWConfig.sentientScent && !this.living && SRPConfigSystems.useScent && worldIn.field_73012_v.nextInt(100) == 0 && entityIn.field_70173_aa % 40 == 0) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(SRPPotions.PREY_E, 1200, 0, false, false));
            }
            if (entityIn.field_70173_aa % 80 == 0) {
                int key = 0;
                NBTTagCompound compound = stack.func_77978_p();
                if (compound != null && EvolutionHandler.getEvolved(stack.func_77973_b()) != null) {
                    if (compound.func_74764_b("srpkills")) {
                        key = compound.func_74762_e("srpkills");
                    }
                    if (key > SRPConfig.weapon_livingSentient_HP_needed) {
                        compound.func_74768_a("srpkills", 0);
                        ItemStack stackW = new ItemStack(EvolutionHandler.getEvolved(stack.func_77973_b()), 1);
                        if (ParasiteSWConfig.evolutionKeepNBT) {
                            stackW.func_77982_d(compound.func_74737_b());
                        }
                        EntityItem entityitem = new EntityItem(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, stackW);
                        if (ParasiteSWConfig.evolutionDropOnGround) {
                            entityitem.func_174869_p();
                        } else {
                            entityitem.func_174868_q();
                        }
                        worldIn.func_72838_d((Entity)entityitem);
                        stack.func_190918_g(1);
                        if (SRPConfig.thunderEnable) {
                            worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, true));
                        }
                    }
                }
            }
        }
    }

    private Vec3d calculateEntityViewVector(float pitch, float yaw) {
        float degToRad = (float)Math.PI / 180;
        float yawCos = MathHelper.func_76134_b((float)(-yaw * degToRad - (float)Math.PI));
        float yawSin = MathHelper.func_76126_a((float)(-yaw * degToRad - (float)Math.PI));
        float pitchCos = -MathHelper.func_76134_b((float)(-pitch * degToRad - (float)Math.PI));
        float pitchSin = MathHelper.func_76126_a((float)(-pitch * degToRad - (float)Math.PI));
        return new Vec3d((double)(yawSin * pitchCos), (double)pitchSin, (double)(yawCos * pitchCos));
    }
}

